/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.request;

import com.lop.open.api.sdk.internal.util.JsonUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DomainHttpParam {
    public static final String CHARSET_UTF8 = "UTF-8";
    private Map<String, String> headers = new HashMap<String, String>();
    private String urlPath = "";
    private Map<String, String> urlArgs = new HashMap<String, String>();
    private List<Object> bodyArgs = new LinkedList<Object>();
    private Object bodyOriginalArgs = new Object();
    private String bodyJsonArgs = "";

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getUrlArgs() {
        return this.urlArgs;
    }

    public void addUrlArg(String key, String value) {
        if (value != null) {
            this.urlArgs.put(key, value);
        }
    }

    public void addUrlArg(Map<String, String> map) {
        if (map != null) {
            this.urlArgs.putAll(map);
        }
    }

    public void addBodyArgs(Object args) {
        this.bodyOriginalArgs = args;
    }

    public void addBodyArgs(List<Object> argsList) {
        if (argsList != null && argsList.size() > 0) {
            this.bodyArgs.addAll(argsList);
        }
    }

    public void addHeaders(String key, String value) {
        if (value != null) {
            this.headers.put(key, value);
        }
    }

    public void addHeaders(Map<String, String> map) {
        if (map != null) {
            this.headers.putAll(map);
        }
    }

    public byte[] getBodyContentBytes() throws IOException {
        return this.getBodyContent().getBytes(CHARSET_UTF8);
    }

    public String getBodyContent() throws IOException {
        if (StringUtil.areNotEmpty(this.bodyJsonArgs)) {
            return this.bodyJsonArgs;
        }
        if (this.bodyArgs != null && this.bodyArgs.size() > 0) {
            return JsonUtil.toJson(this.bodyArgs);
        }
        return JsonUtil.toJson(this.bodyOriginalArgs);
    }

    public String getUrlArgsQuery() throws IOException {
        Map<String, String> params = this.getUrlArgs();
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtil.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, CHARSET_UTF8));
        }
        return query.toString();
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public String getCharset() {
        return null;
    }

    public void addBodyJsonArgs(String bodyJsonArgs) {
        this.bodyJsonArgs = bodyJsonArgs;
    }
}

