/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.template;

import com.lop.open.api.sdk.commons.HttpContentType;
import com.lop.open.api.sdk.internal.util.CodecUtil;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginTemplate;
import com.lop.open.api.sdk.plugin.entity.OAuth2Plugin;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.request.DomainHttpParam;
import com.lop.open.api.sdk.util.DomainApiUtil;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TreeMap;

public class OAuth2Template
extends LopPluginTemplate {
    private static final String JSON_PARAM_KEY = "param_json";

    @Override
    public void buildHeaderParams(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        int zone = dateFormat.getTimeZone().getRawOffset() / 3600 / 1000;
        if (zone > 0) {
            httpParam.addHeaders("lop-tz", "+" + zone);
        } else if (zone < 0) {
            httpParam.addHeaders("lop-tz", "-" + zone);
        } else {
            httpParam.addHeaders("lop-tz", "+0");
        }
    }

    @Override
    public void buildUrlArgs(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        OAuth2Plugin oAuth2Plugin = (OAuth2Plugin)lopPlugin;
        TreeMap<String, String> sysParams = new TreeMap<String, String>();
        TreeMap<String, String> pmap = new TreeMap<String, String>();
        String bodyObjectJson = httpParam.getBodyContent();
        boolean httpDomainApi = DomainApiUtil.isHttpDomainApi(domainRequest.getDomainApiTypeCode());
        if (httpDomainApi) {
            bodyObjectJson = DomainApiUtil.buildHttpBodyObjectsJson(domainRequest.getBodyObject(), HttpContentType.APPLICATION_JSON);
        }
        pmap.put(JSON_PARAM_KEY, bodyObjectJson);
        sysParams.put("method", domainRequest.getApiMethod());
        if (oAuth2Plugin.getAccessToken() != null) {
            sysParams.put("access_token", oAuth2Plugin.getAccessToken());
        } else {
            sysParams.put("access_token", "");
        }
        sysParams.put("app_key", oAuth2Plugin.getAppKey());
        sysParams.put("timestamp", domainRequest.getTimestamp());
        sysParams.put("v", domainRequest.getVersion());
        pmap.putAll(sysParams);
        String signResult = this.sign(pmap, oAuth2Plugin.getAppSecret());
        httpParam.addUrlArg("LOP-DN", domainRequest.getDomain());
        httpParam.addUrlArg("sign", signResult);
        pmap.remove(JSON_PARAM_KEY);
        httpParam.addUrlArg(pmap);
    }

    @Override
    public void buildUrlPath(DomainHttpParam httpParam, DomainAbstractRequest domainRequest, LopPlugin lopPlugin) throws Exception {
        httpParam.setUrlPath(domainRequest.getApiMethod());
    }

    private String sign(Map<String, String> pmap, String appSecret) throws Exception {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            sb.append(entry.getKey());
            sb.append(entry.getValue());
        }
        sb.append(appSecret);
        String result = CodecUtil.md5(sb.toString());
        return result;
    }
}

