/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.plugin.factory;

import com.lop.open.api.sdk.commons.HttpContentType;
import com.lop.open.api.sdk.internal.fastjson.JSON;
import com.lop.open.api.sdk.plugin.LopPlugin;
import com.lop.open.api.sdk.plugin.LopPluginFactory;
import com.lop.open.api.sdk.plugin.entity.HmacCustomizeSign;
import com.lop.open.api.sdk.plugin.entity.HmacPartnerPlugin;
import com.lop.open.api.sdk.plugin.enumerate.EncryptAlgorithm;
import com.lop.open.api.sdk.plugin.enumerate.HmacSourceType;
import com.lop.open.api.sdk.request.DomainAbstractRequest;
import com.lop.open.api.sdk.util.DomainApiUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HmacPartnerPluginFactory
implements LopPluginFactory {
    public static LopPlugin produceLopPlugin(String isvAppSecret, String appKey, DomainAbstractRequest request) {
        return HmacPartnerPluginFactory.produceLopPlugin(isvAppSecret, appKey, request, null);
    }

    public static LopPlugin produceLopPlugin(String isvAppSecret, String appKey, DomainAbstractRequest request, EncryptAlgorithm algorithm) {
        HmacPartnerPlugin plugin = new HmacPartnerPlugin();
        plugin.setIsvAppSecret(isvAppSecret);
        plugin.setAppKey(appKey);
        ArrayList<HmacCustomizeSign> customizeSignList = new ArrayList<HmacCustomizeSign>();
        HmacCustomizeSign isvAppSecretSign = new HmacCustomizeSign();
        isvAppSecretSign.setKey("isv_app_secret");
        isvAppSecretSign.setValue(isvAppSecret);
        isvAppSecretSign.setSourceType(HmacSourceType.SystemVar);
        customizeSignList.add(isvAppSecretSign);
        HmacCustomizeSign appKeyFixedSign = new HmacCustomizeSign();
        appKeyFixedSign.setKey("app_key");
        appKeyFixedSign.setValue("app_key");
        appKeyFixedSign.setSourceType(HmacSourceType.FixedConstant);
        customizeSignList.add(appKeyFixedSign);
        HmacCustomizeSign appKeyArgsSign = new HmacCustomizeSign();
        appKeyArgsSign.setKey("app_key");
        appKeyArgsSign.setValue(appKey);
        appKeyArgsSign.setSourceType(HmacSourceType.UrlArgs);
        customizeSignList.add(appKeyArgsSign);
        HmacCustomizeSign methodFixedSign = new HmacCustomizeSign();
        methodFixedSign.setKey("method");
        methodFixedSign.setValue("method");
        methodFixedSign.setSourceType(HmacSourceType.FixedConstant);
        customizeSignList.add(methodFixedSign);
        HmacCustomizeSign reqUriSign = new HmacCustomizeSign();
        reqUriSign.setKey("req_uri");
        reqUriSign.setValue(request.getApiMethod());
        reqUriSign.setSourceType(HmacSourceType.SystemVar);
        customizeSignList.add(reqUriSign);
        HmacCustomizeSign paramJsonSign = new HmacCustomizeSign();
        paramJsonSign.setKey("param_json");
        paramJsonSign.setValue("param_json");
        paramJsonSign.setSourceType(HmacSourceType.FixedConstant);
        customizeSignList.add(paramJsonSign);
        HmacCustomizeSign requestBodySign = new HmacCustomizeSign();
        requestBodySign.setKey("request_body");
        String bodyObjectJson = JSON.toJSONString(request.getBodyObject());
        boolean httpDomainApi = DomainApiUtil.isHttpDomainApi(request.getDomainApiTypeCode());
        if (httpDomainApi) {
            bodyObjectJson = DomainApiUtil.buildHttpBodyObjectsJson(request.getBodyObject(), HttpContentType.APPLICATION_JSON);
        }
        requestBodySign.setValue(bodyObjectJson);
        requestBodySign.setSourceType(HmacSourceType.SystemVar);
        customizeSignList.add(requestBodySign);
        HmacCustomizeSign timestampFixedSign = new HmacCustomizeSign();
        timestampFixedSign.setKey("timestamp");
        timestampFixedSign.setValue("timestamp");
        timestampFixedSign.setSourceType(HmacSourceType.FixedConstant);
        customizeSignList.add(timestampFixedSign);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = dateFormat.format(new Date());
        HmacCustomizeSign timestampArgsSign = new HmacCustomizeSign();
        timestampArgsSign.setKey("timestamp");
        timestampArgsSign.setValue(timestamp);
        timestampArgsSign.setSourceType(HmacSourceType.UrlArgs);
        customizeSignList.add(timestampArgsSign);
        HmacCustomizeSign vFixedSign = new HmacCustomizeSign();
        vFixedSign.setKey("v");
        vFixedSign.setValue("v");
        vFixedSign.setSourceType(HmacSourceType.FixedConstant);
        customizeSignList.add(vFixedSign);
        HmacCustomizeSign vArgsSign = new HmacCustomizeSign();
        vArgsSign.setKey("v");
        vArgsSign.setValue(request.getVersion());
        vArgsSign.setSourceType(HmacSourceType.UrlArgs);
        customizeSignList.add(vArgsSign);
        HmacCustomizeSign isvAppSecretLastSign = new HmacCustomizeSign();
        isvAppSecretLastSign.setKey("isv_app_secret");
        isvAppSecretLastSign.setValue(isvAppSecret);
        isvAppSecretLastSign.setSourceType(HmacSourceType.SystemVar);
        customizeSignList.add(isvAppSecretLastSign);
        plugin.setVersion("1.0");
        if (algorithm == null) {
            plugin.setAlgorithm(EncryptAlgorithm.md5_salt);
        } else {
            plugin.setAlgorithm(algorithm);
        }
        plugin.setCustomizeSignList(customizeSignList);
        return plugin;
    }

    public static void main(String[] args) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = dateFormat.format(new Date());
        System.out.println(timestamp);
    }
}

