/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.util;

import com.lop.open.api.sdk.plugin.enumerate.EncryptAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

public class HmacUtil {
    private static final String MAC_NAME = "HmacSHA1";
    private static final String ENCODING = "UTF-8";

    public static String getServerTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    public static String MD5(String md5) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(md5.getBytes());
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static byte[] HmacSHA1Encrypt(String encryptText, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes(ENCODING);
        SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes(ENCODING);
        byte[] digest = mac.doFinal(text);
        return digest;
    }

    public static byte[] encrypt(String encryptText, String secret, EncryptAlgorithm algorithm) throws Exception {
        byte[] data = secret.getBytes(ENCODING);
        SecretKeySpec secretKey = new SecretKeySpec(data, algorithm.getName());
        Mac mac = Mac.getInstance(algorithm.getName());
        mac.init(secretKey);
        byte[] text = encryptText.getBytes(ENCODING);
        byte[] digest = mac.doFinal(text);
        return digest;
    }

    public static Map<String, String> makeHmacHeaders(String userName, String secret, Algorithm algorithm, Map<String, String> extendSignProperties) {
        if (userName == null || secret == null || algorithm == null) {
            throw new IllegalArgumentException("\u7528\u6237\u540d/\u5bc6\u7801/\u7b7e\u540d\u7b97\u6cd5\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String X_Date = HmacUtil.getServerTime();
        String txt = "X-Date: " + X_Date;
        String headers = "X-Date";
        result.put("X-Date", X_Date);
        if (extendSignProperties != null) {
            for (Map.Entry<String, String> entry : extendSignProperties.entrySet()) {
                txt = txt + "\n" + entry.getKey() + ": " + entry.getValue();
                headers = headers + " " + entry.getKey();
                result.put(entry.getKey(), entry.getValue());
            }
        }
        String sign = null;
        if (algorithm == Algorithm.hmac_sha1) {
            try {
                byte[] digest = HmacUtil.HmacSHA1Encrypt(txt, secret);
                sign = new BASE64Encoder().encode(digest);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (algorithm == Algorithm.md5_salt) {
            String md5Sign = HmacUtil.MD5(secret + txt + secret);
            sign = md5Sign.toLowerCase();
        } else {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + algorithm.getName());
        }
        result.put("Authorization", "hmac username=\"" + userName + "\", algorithm=\"" + algorithm.getName() + "\", headers=\"" + headers + "\",signature=\"" + sign + "\"");
        return result;
    }

    public static Map<String, String> makeHmacCustomizeHeaders(List<String> antiTamperList, Algorithm algorithm) {
        if (antiTamperList == null || algorithm == null) {
            throw new IllegalArgumentException("secret/\u7b7e\u540d\u7b97\u6cd5\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String txt = String.join((CharSequence)"", antiTamperList);
        String md5Sign = HmacUtil.MD5(txt);
        String sign = md5Sign.toLowerCase();
        result.put("sign", sign);
        return result;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> extendProperties = new HashMap<String, String>();
        extendProperties.put("md5-content", HmacUtil.MD5("replace to your request body"));
        Map<String, String> headers = HmacUtil.makeHmacHeaders("user1", "pwd", Algorithm.hmac_sha1, extendProperties);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
        System.out.println(HmacUtil.getServerTime());
        System.out.println(HmacUtil.MD5("replace to your request body"));
        byte[] digest = HmacUtil.HmacSHA1Encrypt("hailongnihao", "hailong");
        System.out.println(new BASE64Encoder().encode(digest));
    }

    public static enum Algorithm {
        hmac_sha1("hmac-sha1"),
        md5_salt("md5-salt");

        private String name;

        private Algorithm(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

