/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.util;

import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.internal.parser.Parser;
import com.lop.open.api.sdk.internal.parser.ParserFactory;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.response.AbstractResponse;
import java.security.MessageDigest;
import java.util.Map;

public final class CodecUtil {
    private CodecUtil() {
        throw new UnsupportedOperationException();
    }

    public static String md5(String source) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = md.digest(source.getBytes("utf-8"));
        return CodecUtil.byte2hex(bytes);
    }

    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static <T extends AbstractResponse> T parse(String rsp, Class<T> responseClass) throws LopException {
        Parser parser = ParserFactory.getJsonParser();
        return parser.parse(rsp, responseClass);
    }

    public static String sign(Map<String, String> pmap, String appSecret) throws Exception {
        StringBuilder sb = new StringBuilder(appSecret);
        for (Map.Entry<String, String> entry : pmap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtil.areNotEmpty(name, value)) continue;
            sb.append(name).append(value);
        }
        sb.append(appSecret);
        String result = CodecUtil.md5(sb.toString());
        return result;
    }
}

