/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.parser;

import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.internal.fastjson.JSON;
import com.lop.open.api.sdk.internal.fastjson.JSONObject;
import com.lop.open.api.sdk.internal.parser.Parser;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.response.AbstractResponse;

public class JsonParser
implements Parser {
    @Override
    public <T extends AbstractResponse> T parse(String json, Class<T> responseClass) throws LopException {
        AbstractResponse response = null;
        try {
            if (StringUtil.isEmpty(json)) {
                throw new LopException("response json is empty!");
            }
            response = (AbstractResponse)this.fromJson(json, responseClass);
            if (response != null) {
                response.setMsg(json);
            }
        }
        catch (Exception e) {
            throw new LopException(e);
        }
        return (T)response;
    }

    public <T extends AbstractResponse> T fromJson(String json, Class<T> responseClass) throws Exception {
        JSONObject jsonObject = JSON.parseObject(json);
        String response = jsonObject.getString("response");
        if (response == null) {
            response = jsonObject.getString("error_response");
        }
        if (response == null) {
            throw new LopException("\u89e3\u6790Json\u5f02\u5e38:" + json);
        }
        return (T)((AbstractResponse)JSON.parseObject(response, responseClass));
    }

    public <T> T parseJson(String json, Class<T> objClass) throws LopException {
        T t = null;
        try {
            if (StringUtil.isEmpty(json)) {
                throw new LopException("response json is empty!");
            }
            t = JSON.parseObject(json, objClass);
        }
        catch (Exception e) {
            throw new LopException("parse json error, json:" + json, e);
        }
        return t;
    }
}

