/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.msg.utils;

import com.lop.open.api.sdk.internal.fastjson.JSON;
import com.lop.open.api.sdk.internal.msg.pojo.LopMessage;
import com.lop.open.api.sdk.internal.msg.pojo.LopMsgStatus;
import com.lop.open.api.sdk.internal.util.JsonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MessageUtils {
    public static final String PIN = "pin";
    public static final String MSG_ID = "msgId";
    public static final String MSG_NAME = "msgName";
    public static final String MSG_PAYLOAD = "msgPayload";

    public static LopMessage parse(String message) {
        LopMessage lopMsg = new LopMessage();
        try {
            Map msgMap = (Map)JSON.parse(message);
            if (msgMap != null && !msgMap.isEmpty()) {
                lopMsg.setPin((String)msgMap.get(PIN));
                lopMsg.setMsgId((String)msgMap.get(MSG_ID));
                lopMsg.setMsgName((String)msgMap.get(MSG_NAME));
                String payLoad = (String)msgMap.get(MSG_PAYLOAD);
                if (payLoad != null && payLoad.length() > 0) {
                    lopMsg.setMsgPayloadRaw(payLoad);
                    lopMsg.setMsgPlyloadText(payLoad);
                    lopMsg.setMsgPayload((Map)JSON.parse(payLoad));
                }
            }
        }
        catch (Exception e) {
            lopMsg.setMsgPayloadRaw(message);
        }
        return lopMsg;
    }

    public static String genConfirmMsg(LopMsgStatus status) {
        HashMap<String, String> content = new HashMap<String, String>();
        if (status.getMsgId() != null && status.getMsgId().length() > 0) {
            content.put(MSG_ID, status.getMsgId());
            content.put("name", "commit");
        }
        if (status.isFail()) {
            content.put("reason", status.getReason());
        }
        return JSON.toJSONString(content);
    }

    public static Object getMsgObject(String msgName, String msgPayload) {
        String[] params = msgName.split("_");
        String group = params[1];
        String className = params[2];
        String classFullName = "com.lop.open.api.sdk.msg.domain." + group + "." + className;
        Object obj = null;
        try {
            Class<?> c = Class.forName(classFullName);
            obj = JsonUtil.fromJson(msgPayload, c);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

