/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk.internal.msg;

import com.lop.open.api.sdk.internal.msg.LopWSAdapter;
import com.lop.open.api.sdk.internal.msg.MessageProcessor;
import com.lop.open.api.sdk.internal.msg.utils.WebsocketUtils;
import com.lop.open.api.sdk.internal.msg.wsclient.ProxySettings;
import com.lop.open.api.sdk.internal.msg.wsclient.WebSocket;
import com.lop.open.api.sdk.internal.msg.wsclient.WebSocketFactory;
import com.lop.open.api.sdk.internal.util.StringUtil;
import java.util.Date;

public class LopMsgClient {
    private String appKey;
    private String appSecret;
    private String groupName;
    private String timestamp;
    private int timeout = 0;
    private final int pingInterval = 30000;
    private MessageProcessor messageProcessor;
    private LopWSAdapter lopWSAdapter;
    private WebSocket ws;

    public LopMsgClient(String appKey, String appSecret, String groupName) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.groupName = groupName;
        this.timestamp = WebsocketUtils.genTimestamp(new Date());
        this.lopWSAdapter = new LopWSAdapter(this);
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }

    public void setMessageProcessor(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void connect(String uri) throws Exception {
        this.connect(uri, null, -1);
    }

    public void connect(String uri, String host, int port) throws Exception {
        WebSocketFactory webSocketFactory = new WebSocketFactory();
        ProxySettings proxySettings = webSocketFactory.getProxySettings();
        if (StringUtil.areNotEmpty(host)) {
            proxySettings.setHost(host);
        }
        proxySettings.setPort(port);
        this.ws = webSocketFactory.setConnectionTimeout(this.timeout).createSocket(this.assembleUri(uri)).addListener(this.lopWSAdapter.setMessageProcessor(this.messageProcessor)).addExtension("permessage-deflate").setPingInterval(30000L).connect();
        this.ws.sendPing();
    }

    private String assembleUri(String uri) throws Exception {
        StringBuffer uriBuf = new StringBuffer(uri);
        if (uri.contains("?")) {
            uriBuf.append("&").append("app_key").append("=").append(this.appKey);
        } else {
            uriBuf.append("?").append("app_key").append("=").append(this.appKey);
        }
        uriBuf.append("&").append("group").append("=").append(this.groupName);
        uriBuf.append("&").append("timestamp").append("=").append(this.timestamp);
        uriBuf.append("&").append("v").append("=").append("2.0");
        uriBuf.append("&").append("sign").append("=").append(WebsocketUtils.genSign(this.appKey, this.groupName, this.timestamp, this.appSecret));
        String encodeUri = uriBuf.toString().replaceAll(" ", "%20");
        return encodeUri;
    }

    public void sendMessage(String message) {
        this.ws.sendText(message);
    }

    public void close() {
        this.close("Lop Message client closed");
    }

    public void close(String reason) {
        if (this.lopWSAdapter != null) {
            this.lopWSAdapter.close();
        }
        if (this.lopWSAdapter.getThreadPool() != null) {
            this.lopWSAdapter.getThreadPool().shutdown();
        }
        this.ws.disconnect(reason);
    }

    public void setWebsocket(WebSocket websocket) {
        this.ws = websocket;
    }

    public WebSocket getWebsocket() {
        return this.ws;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }
}

