/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk;

import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.internal.bean.TokenResult;
import com.lop.open.api.sdk.internal.parser.JsonParser;
import com.lop.open.api.sdk.internal.util.CodecUtil;
import com.lop.open.api.sdk.internal.util.HttpUtil;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import java.net.Proxy;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TokenClient {
    public static final String CHARSET_UTF8 = "UTF-8";
    private static final String OTHER_PARAM_KEY = "other";
    private String serverUrl;
    private static int connectTimeout = 0;
    private static int readTimeout = 0;
    private static String TOKEN_INVALID_CODE = "19";
    private static String TOKEN_EXPIRED_CODE = "29";
    private static String REFRESH_TOKEN_EXPIRED_CODE = "30";
    private String appKey;
    private String appSecret;
    private Proxy proxy;

    public TokenClient(String serverUrl, String appKey, String appSecret) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public TokenClient(String serverUrl, String appKey, String appSecret, Proxy proxy) {
        this.serverUrl = serverUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.proxy = proxy;
    }

    public static boolean isAccessTokenExpired(String errorCode) {
        return TOKEN_INVALID_CODE.equals(errorCode) || TOKEN_EXPIRED_CODE.equals(errorCode);
    }

    public static boolean isRefreshTokenExpired(String errorCode) {
        return REFRESH_TOKEN_EXPIRED_CODE.equals(errorCode);
    }

    public TokenResult getToken(String code) {
        String getToken_url = this.serverUrl + "/get_token?code=" + code;
        String rsp = "";
        try {
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(connectTimeout).setReadTimeout(readTimeout).setUrl(getToken_url).setProxy(this.proxy != null ? this.proxy : null).instance();
            rsp = HttpUtil.doPost(postInfo);
        }
        catch (Exception e) {
            rsp = "{\"errMsg\":\"network failure, call failure!\",\"errCode\":\"-1\",\"success\":false}";
        }
        JsonParser jsonParser = new JsonParser();
        TokenResult tokenResult = null;
        try {
            tokenResult = jsonParser.parseJson(rsp, TokenResult.class);
        }
        catch (LopException e) {
            tokenResult = new TokenResult();
            tokenResult.setErrCode("-1");
            tokenResult.setErrMsg("rsp format json error!");
        }
        return tokenResult;
    }

    private TokenResult refreshToken(String refreshToken) throws LopException {
        String rsp;
        String sign;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String timestamp = dateFormat.format(new Date());
        StringBuilder url = new StringBuilder(200);
        url.append(this.serverUrl).append("/oauth/refresh_token_ext?LOP-DN=oauth.jdwl.com&app_key=").append(this.appKey).append("&refresh_token=").append(refreshToken).append("&timestamp=");
        StringBuilder param = new StringBuilder(200);
        param.append(this.appSecret).append("app_key").append(this.appKey).append("refresh_token").append(refreshToken).append("timestamp").append(timestamp).append(this.appSecret);
        try {
            url.append(URLEncoder.encode(timestamp, CHARSET_UTF8));
            sign = CodecUtil.md5(param.toString());
        }
        catch (Exception e) {
            throw new LopException("build url error", e);
        }
        url.append("&sign=").append(sign);
        try {
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(connectTimeout).setReadTimeout(readTimeout).setUrl(url.toString()).setProxy(this.proxy != null ? this.proxy : null).instance();
            rsp = HttpUtil.doPost(postInfo);
        }
        catch (Exception e) {
            throw new LopException(e);
        }
        JsonParser jsonParser = new JsonParser();
        TokenResult tokenResult = jsonParser.parseJson(rsp, TokenResult.class);
        return tokenResult;
    }

    public String getRefreshToken(String refreshToken) throws LopException {
        TokenResult tokenResult = this.refreshToken(refreshToken);
        if (tokenResult == null) {
            return null;
        }
        if (tokenResult.isSuccess()) {
            if (tokenResult.getModel() == null) {
                return null;
            }
            return tokenResult.getModel().getAccessToken();
        }
        throw new LopException(tokenResult.getErrMsg());
    }
}

