/*
 * Decompiled with CFR 0.152.
 */
package com.lop.open.api.sdk;

import com.lop.open.api.sdk.LopClient;
import com.lop.open.api.sdk.LopException;
import com.lop.open.api.sdk.TokenClient;
import com.lop.open.api.sdk.internal.util.CodecUtil;
import com.lop.open.api.sdk.internal.util.HttpUtil;
import com.lop.open.api.sdk.internal.util.StringUtil;
import com.lop.open.api.sdk.request.LopRequest;
import com.lop.open.api.sdk.request.info.HttpPostInfo;
import com.lop.open.api.sdk.response.AbstractResponse;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class DefaultLopClient
implements LopClient {
    public static final String CHARSET_UTF8 = "UTF-8";
    private static final String JSON_PARAM_KEY = "param_json";
    private static final String OTHER_PARAM_KEY = "other";
    private static final String API_PATH = "/routerjson";
    private static final String URL_SEPARATOR = "/";
    private String serverUrl;
    private String appKey;
    private String appSecret;
    private String accessToken;
    private String refreshToken;
    private String fuzz;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean useJosAuth = false;
    private Proxy proxy;

    public DefaultLopClient(String serverUrl, String accessToken, String appKey, String appSecret) {
        this.serverUrl = serverUrl.trim();
        this.accessToken = accessToken.trim();
        this.appKey = appKey.trim();
        this.appSecret = appSecret.trim();
    }

    public DefaultLopClient(String serverUrl, String accessToken, String appKey, String appSecret, Proxy proxy) {
        this.serverUrl = serverUrl.trim();
        this.accessToken = accessToken.trim();
        this.appKey = appKey.trim();
        this.appSecret = appSecret.trim();
        this.proxy = proxy;
    }

    public DefaultLopClient(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public DefaultLopClient(String serverUrl, String accessToken, String appKey, String appSecret, String fuzz) {
        this.serverUrl = serverUrl.trim();
        this.accessToken = accessToken.trim();
        this.appKey = appKey.trim();
        this.appSecret = appSecret.trim();
        this.fuzz = fuzz.trim();
    }

    public DefaultLopClient(String serverUrl, String accessToken, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this(serverUrl, accessToken, appKey, appSecret);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultLopClient(Builder builder) {
        this.serverUrl = builder.serverUrl;
        this.appKey = builder.appKey;
        this.appSecret = builder.appSecret;
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.fuzz = builder.fuzz;
        this.useJosAuth = builder.useJosAuth;
        this.proxy = builder.proxy;
    }

    public DefaultLopClient() {
    }

    public static DefaultLopClient getInstance(String serverUrl, String appKey, String appSecret, String refreshToken) throws LopException {
        return new Builder(serverUrl, appKey, appSecret, refreshToken).build();
    }

    @Override
    public void setUseJosAuth(boolean useJosAuth) {
        this.useJosAuth = useJosAuth;
    }

    private <T extends AbstractResponse> T executeRequest(LopRequest<T> request) throws LopException {
        try {
            String url = this.buildUrl(request);
            HashMap<String, String> headParams = new HashMap<String, String>();
            String json = request.getAppJsonParams();
            headParams.put(JSON_PARAM_KEY, json);
            if (request.getOtherParams() != null) {
                headParams.put(OTHER_PARAM_KEY, request.getOtherParams());
            }
            HttpPostInfo postInfo = new HttpPostInfo.Builder().setConnectTimeout(this.connectTimeout).setReadTimeout(this.readTimeout).setUrl(url).setHeadParams(headParams).setUseJosAuth(this.useJosAuth).setProxy(this.proxy != null ? this.proxy : null).instance();
            String rsp = HttpUtil.doPostNoHeadersParam(postInfo);
            T resp = CodecUtil.parse(rsp, request.getResponseClass());
            StringBuffer sb = new StringBuffer();
            sb.append(url).append("&").append(JSON_PARAM_KEY).append("=").append(json);
            ((AbstractResponse)resp).setUrl(sb.toString());
            return resp;
        }
        catch (Exception e) {
            throw new LopException(e);
        }
    }

    @Override
    public <T extends AbstractResponse> T execute(LopRequest<T> request) throws LopException {
        T resp = this.executeRequest(request);
        if (TokenClient.isAccessTokenExpired(((AbstractResponse)resp).getCode())) {
            TokenClient tokenClient = new TokenClient(DefaultLopClient.getBaseUrl(this.serverUrl), this.appKey, this.appSecret);
            this.accessToken = tokenClient.getRefreshToken(this.refreshToken);
            return this.executeRequest(request);
        }
        return resp;
    }

    private <T extends AbstractResponse> String buildUrl(LopRequest<T> request) throws Exception {
        Map<String, String> sysParams = request.getSysParams();
        TreeMap<String, String> pmap = new TreeMap<String, String>();
        pmap.put(JSON_PARAM_KEY, request.getAppJsonParams());
        sysParams.put("method", request.getApiMethod());
        sysParams.put("access_token", this.accessToken);
        sysParams.put("app_key", this.appKey);
        if (this.fuzz != null) {
            sysParams.put("jos_result_fuzz", this.fuzz);
        }
        pmap.putAll(sysParams);
        String sign = CodecUtil.sign(pmap, this.appSecret);
        sysParams.put("sign", sign);
        StringBuilder sb = new StringBuilder(this.serverUrl);
        sb.append("?");
        sb.append(HttpUtil.buildQuery(sysParams, CHARSET_UTF8));
        return sb.toString();
    }

    @Override
    public String obj2Xml(String str, Object object) throws JAXBException, ClassNotFoundException {
        Class<?> clas = Class.forName(str);
        StringWriter stringWriter = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clas});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal(object, (Writer)stringWriter);
        String xml = stringWriter.toString();
        return xml;
    }

    private static String getBaseUrl(String serverUrl) throws LopException {
        StringBuilder baseUrl = new StringBuilder(100);
        try {
            URL url = new URL(serverUrl);
            String host = url.getHost();
            if (StringUtil.isEmpty(host)) {
                throw new LopException("invalid serverUrl:" + serverUrl);
            }
            baseUrl.append(url.getProtocol()).append("://").append(host);
            if (!"-1".equals(url.getPort() + "")) {
                baseUrl.append(":").append(url.getPort());
            }
        }
        catch (MalformedURLException e) {
            throw new LopException(e);
        }
        return baseUrl.toString();
    }

    @Override
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public static final class Builder {
        private String serverUrl;
        private String appKey;
        private String appSecret;
        private String accessToken;
        private String refreshToken;
        private String fuzz;
        private Proxy proxy;
        private int connectTimeout = 0;
        private int readTimeout = 0;
        private boolean useJosAuth = false;

        public Builder(String serverUrl, String appKey, String appSecret, String refreshToken) {
            this.serverUrl = serverUrl;
            this.appKey = appKey;
            this.appSecret = appSecret;
            this.refreshToken = refreshToken;
        }

        public Builder() {
        }

        public Builder addServerUrl(String serverUrl) {
            this.serverUrl = serverUrl.trim();
            return this;
        }

        public Builder addAppKey(String appKey) {
            this.appKey = appKey.trim();
            return this;
        }

        public Builder addAppSecret(String appSecret) {
            this.appSecret = appSecret.trim();
            return this;
        }

        public Builder addAccessToken(String accessToken) {
            this.accessToken = accessToken.trim();
            return this;
        }

        public Builder addRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken.trim();
            return this;
        }

        public Builder addFuzz(String fuzz) {
            this.fuzz = fuzz.trim();
            return this;
        }

        public Builder addConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder addReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder addUseJosAuth(boolean useJosAuth) {
            this.useJosAuth = useJosAuth;
            return this;
        }

        public Builder addProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public DefaultLopClient build() throws LopException {
            if (StringUtil.isEmpty(this.accessToken)) {
                if (StringUtil.isEmpty(this.serverUrl)) {
                    throw new LopException("serverUrl can not be null");
                }
                String baseUrl = DefaultLopClient.getBaseUrl(this.serverUrl);
                if (StringUtil.isEmpty(this.appKey)) {
                    throw new LopException("appKey can not be null");
                }
                if (StringUtil.isEmpty(this.appSecret)) {
                    throw new LopException("appSecret can not be null");
                }
                if (StringUtil.isEmpty(this.refreshToken)) {
                    throw new LopException("refreshToken can not be null");
                }
                TokenClient tokenClient = new TokenClient(baseUrl, this.appKey, this.appSecret);
                this.accessToken = tokenClient.getRefreshToken(this.refreshToken);
            }
            return new DefaultLopClient(this);
        }
    }
}

